/*
 * Decompiled with CFR 0.152.
 */
package net.algart.drawing3d;

import net.algart.drawing3d.Orientation3D;

public final class CoordinateSystem3D
implements Cloneable {
    private double originX;
    private double originY;
    private double originZ;
    private double scale;
    private double scaleInv;
    private Orientation3D orientation;

    public CoordinateSystem3D() {
        this(0.0, 0.0, 0.0, 1.0, Orientation3D.DEFAULT);
    }

    public CoordinateSystem3D(double d, double d2, double d3, double d4, Orientation3D orientation3D) {
        if (orientation3D == null) {
            throw new NullPointerException("Null orientation argument");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("Negative or zero scale = " + d4);
        }
        this.originX = d;
        this.originY = d2;
        this.originZ = d3;
        this.scale = d4;
        this.scaleInv = 1.0 / d4;
        this.orientation = orientation3D;
    }

    public double getOriginX() {
        return this.originX;
    }

    public double getOriginY() {
        return this.originY;
    }

    public double getOriginZ() {
        return this.originZ;
    }

    public void setOrigin(double d, double d2, double d3) {
        this.originX = d;
        this.originY = d2;
        this.originZ = d3;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Negative or zero scale = " + d);
        }
        this.scale = d;
    }

    public Orientation3D getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation3D orientation3D) {
        if (orientation3D == null) {
            throw new NullPointerException("Null orientation argument");
        }
        this.orientation = orientation3D;
    }

    public double transformX(double d, double d2, double d3) {
        return this.originX + this.scale * this.orientation.transformX(d, d2, d3);
    }

    public double transformY(double d, double d2, double d3) {
        return this.originY + this.scale * this.orientation.transformY(d, d2, d3);
    }

    public double transformZ(double d, double d2, double d3) {
        return this.originZ + this.scale * this.orientation.transformZ(d, d2, d3);
    }

    public double inverseTransformX(double d, double d2, double d3) {
        return this.scaleInv * this.orientation.inverseTransformX(d - this.originX, d2 - this.originY, d3 - this.originZ);
    }

    public double inverseTransformY(double d, double d2, double d3) {
        return this.scaleInv * this.orientation.inverseTransformY(d - this.originX, d2 - this.originY, d3 - this.originZ);
    }

    public double inverseTransformZ(double d, double d2, double d3) {
        return this.scaleInv * this.orientation.inverseTransformZ(d - this.originX, d2 - this.originY, d3 - this.originZ);
    }

    public CoordinateSystem3D clone() {
        try {
            return (CoordinateSystem3D)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        return "coordinate system: origin = (" + this.originX + ", " + this.originY + ", " + this.originZ + "), scale = " + this.scale + ", orientation = (" + this.orientation + ')';
    }
}

