/*
 * Decompiled with CFR 0.152.
 */
package net.algart.drawing3d;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.algart.drawing3d.ColoringRule;
import net.algart.drawing3d.CoordinateSystem3D;
import net.algart.drawing3d.DrawingRule;
import net.algart.drawing3d.Orientation3D;
import net.algart.drawing3d.Pixel3DDrawer;
import net.algart.drawing3d.Shape3D;
import net.algart.drawing3d.ShapingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Drawer3D
implements Pixel3DDrawer {
    protected final int screenWidth;
    protected final int screenHeight;
    protected double zCut = Double.POSITIVE_INFINITY;
    private ArrayList<ShapingRule> shapingRules;
    private ArrayList<ColoringRule> coloringRules;
    private ArrayList<DrawingRule> drawingRules;
    private CoordinateSystem3D coordinateSystem;
    private Color backgroundColor = Color.BLACK;
    private double gamma;
    private int[] gammaTable = new int[257];

    protected Drawer3D(int n, int n2, Color color, Collection<ShapingRule> collection, Collection<ColoringRule> collection2, Collection<DrawingRule> collection3) {
        this.setGamma(1.0);
        if (color == null) {
            throw new NullPointerException("Null backgroundColor argument");
        }
        if (collection == null) {
            throw new NullPointerException("Null shapingRules argument");
        }
        if (collection2 == null) {
            throw new NullPointerException("Null coloringRules argument");
        }
        if (collection3 == null) {
            throw new NullPointerException("Null drawingRules argument");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative screen width");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative screen height");
        }
        this.screenWidth = n;
        this.screenHeight = n2;
        this.backgroundColor = color;
        this.shapingRules = Drawer3D.cloneListWithoutNulls(collection);
        this.coloringRules = Drawer3D.cloneListWithoutNulls(collection2);
        this.drawingRules = Drawer3D.cloneListWithoutNulls(collection3);
        this.coordinateSystem = new CoordinateSystem3D(0.0, 0.0, 0.0, 1.0, Orientation3D.DEFAULT);
    }

    public List<ShapingRule> getShapingRules() {
        return Collections.unmodifiableList(this.shapingRules);
    }

    public void setShapingRules(Collection<ShapingRule> collection) {
        if (collection == null) {
            throw new NullPointerException("Null shapingRules argument");
        }
        this.shapingRules = Drawer3D.cloneListWithoutNulls(collection);
    }

    public void setShapingRules(ShapingRule ... shapingRuleArray) {
        if (shapingRuleArray == null) {
            throw new NullPointerException("Null shapingRules argument");
        }
        this.setShapingRules(Arrays.asList(shapingRuleArray));
    }

    public List<ColoringRule> getColoringRules() {
        return Collections.unmodifiableList(this.coloringRules);
    }

    public void setColoringRules(Collection<ColoringRule> collection) {
        if (collection == null) {
            throw new NullPointerException("Null coloringRules argument");
        }
        this.coloringRules = Drawer3D.cloneListWithoutNulls(collection);
    }

    public void setColoringRules(ColoringRule ... coloringRuleArray) {
        if (coloringRuleArray == null) {
            throw new NullPointerException("Null coloringRules argument");
        }
        this.setColoringRules(Arrays.asList(coloringRuleArray));
    }

    public List<DrawingRule> getDrawingRules() {
        return Collections.unmodifiableList(this.drawingRules);
    }

    public void setDrawingRules(Collection<DrawingRule> collection) {
        if (collection == null) {
            throw new NullPointerException("Null drawingRules argument");
        }
        this.drawingRules = Drawer3D.cloneListWithoutNulls(collection);
    }

    public void setDrawingRules(DrawingRule ... drawingRuleArray) {
        if (drawingRuleArray == null) {
            throw new NullPointerException("Null drawingRules argument");
        }
        this.setDrawingRules(Arrays.asList(drawingRuleArray));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            throw new NullPointerException("Null backgroundColor argument");
        }
        this.backgroundColor = color;
    }

    public CoordinateSystem3D getCoordinateSystem() {
        return this.coordinateSystem.clone();
    }

    public void setCoordinateSystem(CoordinateSystem3D coordinateSystem3D) {
        if (coordinateSystem3D == null) {
            throw new NullPointerException("Null coordinateSystem argument");
        }
        this.coordinateSystem = coordinateSystem3D.clone();
    }

    public double getZCut() {
        return this.zCut;
    }

    public void setZCut(double d) {
        this.zCut = d;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Illegal gamma " + d + ": it must be positive");
        }
        this.gamma = d;
        for (int i = 0; i <= 256; ++i) {
            this.gammaTable[i] = (int)(256.0 * Math.pow((double)i / 256.0, this.gamma) + 0.5);
        }
    }

    public final int getScreenWidth() {
        return this.screenWidth;
    }

    public final int getScreenHeight() {
        return this.screenHeight;
    }

    public abstract int getImageWidth();

    public abstract int getImageHeight();

    @Override
    public abstract void clearRect(int var1, int var2, int var3, int var4);

    @Override
    public abstract void drawPoint(int var1, int var2, double var3, double var5, double var7, double var9, Color var11);

    public abstract BufferedImage getImage();

    public Shape3D getShape(Object object) {
        if (object == null) {
            return null;
        }
        for (ShapingRule shapingRule : this.shapingRules) {
            if (!shapingRule.isApplicable(object)) continue;
            return shapingRule.getShape(object);
        }
        if (object instanceof Shape3D) {
            return (Shape3D)object;
        }
        return null;
    }

    public Color getColor(Object object) {
        if (object == null) {
            return null;
        }
        for (ColoringRule coloringRule : this.coloringRules) {
            if (!coloringRule.isApplicable(object)) continue;
            return coloringRule.getColor(object);
        }
        return null;
    }

    public DrawingRule getDrawingRule(Shape3D shape3D, Object object) {
        if (shape3D == null) {
            return null;
        }
        for (DrawingRule drawingRule : this.drawingRules) {
            if (!drawingRule.isApplicable(shape3D, object)) continue;
            return drawingRule;
        }
        return null;
    }

    public void draw(Object ... objectArray) {
        this.draw(Arrays.asList(objectArray));
    }

    public void draw(Collection<?> collection) {
        if (collection == null) {
            throw new NullPointerException("Null items argument");
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.screenWidth, this.screenHeight);
        for (Object obj : collection) {
            DrawingRule drawingRule;
            Color color;
            Shape3D shape3D = this.getShape(obj);
            if (shape3D == null || (color = this.getColor(obj)) == null || (drawingRule = this.getDrawingRule(shape3D, obj)) == null) continue;
            drawingRule.draw(shape3D, this, this.coordinateSystem, double_, this.zCut, color);
        }
    }

    public boolean estimateContainingParallelepiped(double[] dArray, Collection<?> collection) {
        if (dArray == null) {
            throw new NullPointerException("Null result argument");
        }
        if (collection == null) {
            throw new NullPointerException("Null items argument");
        }
        if (dArray.length < 6) {
            throw new IndexOutOfBoundsException("result.length = " + dArray.length + " < 6");
        }
        double[] dArray2 = new double[6];
        boolean bl = false;
        for (Object obj : collection) {
            DrawingRule drawingRule;
            Shape3D shape3D = this.getShape(obj);
            if (shape3D == null || (drawingRule = this.getDrawingRule(shape3D, obj)) == null) continue;
            drawingRule.estimateContainingParallelepiped(dArray2, shape3D, this.coordinateSystem);
            if (!bl) {
                System.arraycopy(dArray2, 0, dArray, 0, 6);
                bl = true;
                continue;
            }
            dArray[0] = Math.min(dArray[0], dArray2[0]);
            dArray[1] = Math.max(dArray[1], dArray2[1]);
            dArray[2] = Math.min(dArray[2], dArray2[2]);
            dArray[3] = Math.max(dArray[3], dArray2[3]);
            dArray[4] = Math.min(dArray[4], dArray2[4]);
            dArray[5] = Math.max(dArray[5], dArray2[5]);
        }
        return bl;
    }

    protected int gammaCorrection(int n) {
        return this.gammaTable[n];
    }

    private static <T> ArrayList<T> cloneListWithoutNulls(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : collection) {
            if (t == null) {
                throw new NullPointerException("Null element of the list (" + collection.getClass() + ")");
            }
            arrayList.add(t);
        }
        return arrayList;
    }
}

