/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement;

import java.awt.Color;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import net.algart.model3d.common.movement.MovingSpheresController;
import net.algart.model3d.common.movement.MovingSpheresModel;
import net.algart.model3d.common.movement.MovingSpheresView;
import net.algart.model3d.common.movement.ParameterGetter;
import net.algart.model3d.common.movement.StatusShower;
import net.algart.model3d.common.movement.model.ElasticBall;

public class MovingSpheresApplet
extends JApplet
implements ParameterGetter,
StatusShower {
    private static final int CORRECTING_MODEL_TIMEOUT = 3000;
    public final boolean appletReady = true;
    protected MovingSpheresModel model = null;
    protected MovingSpheresView view = null;
    protected MovingSpheresController controller = null;
    private volatile double refreshTime = 0.25;
    private RunThread runThread = null;
    private volatile boolean movingActive = false;
    private volatile boolean safeModeForChangingModel = true;
    private volatile boolean wantToChangeModel = false;
    private volatile boolean stopRequested = false;
    private static final long serialVersionUID = -3076441013858415706L;

    public void init() {
        String string = this.getParameter("refresh-time");
        if (string != null) {
            this.refreshTime = Double.parseDouble(string);
        }
        if ((string = this.getParameter("moving-active")) != null) {
            this.movingActive = Boolean.parseBoolean(string);
        }
        this.model = this.createModel();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    MovingSpheresApplet.this.initGUI();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("Cannot initialize GUI normally: " + exception);
        }
    }

    public synchronized void start() {
        if (this.view == null) {
            throw new AssertionError((Object)"INTERNAL ERROR: Applet is not initialized yet");
        }
        if (this.runThread != null) {
            throw new IllegalStateException("Already started");
        }
        this.runThread = new RunThread();
        this.runThread.start();
    }

    public synchronized void stop() {
        if (this.runThread != null) {
            this.stopRequested = true;
            this.notifyAll();
        }
    }

    public synchronized boolean tryStop(long l) {
        if (this.runThread == null) {
            return true;
        }
        this.stopRequested = true;
        this.notifyAll();
        long l2 = System.currentTimeMillis();
        do {
            long l3;
            if ((l3 = System.currentTimeMillis() - l2) >= l) {
                return false;
            }
            try {
                this.wait(l - l3);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        } while (this.runThread != null);
        return true;
    }

    public synchronized void startMovement() {
        this.movingActive = true;
        this.notifyAll();
    }

    public synchronized void stopMovement() {
        this.movingActive = false;
        this.controller.requestRedraw();
        this.notifyAll();
    }

    public synchronized void resetRandSeed() {
        this.model.resetRandSeed();
    }

    public synchronized void setRandSeed(long l) {
        this.model.setRandSeed(l);
    }

    public synchronized double getBunkerMinX() {
        return this.model.getBunkerMinX();
    }

    public synchronized void setBunkerMinX(double d) {
        this.model.setBunkerMinX(d);
    }

    public synchronized double getBunkerMaxX() {
        return this.model.getBunkerMaxX();
    }

    public synchronized void setBunkerMaxX(double d) {
        this.model.setBunkerMaxX(d);
    }

    public synchronized double getBunkerMinY() {
        return this.model.getBunkerMinY();
    }

    public synchronized void setBunkerMinY(double d) {
        this.model.setBunkerMinY(d);
    }

    public synchronized double getBunkerMaxY() {
        return this.model.getBunkerMaxY();
    }

    public synchronized void setBunkerMaxY(double d) {
        this.model.setBunkerMaxY(d);
    }

    public synchronized double getBunkerMinZ() {
        return this.model.getBunkerMinZ();
    }

    public synchronized void setBunkerMinZ(double d) {
        this.model.setBunkerMinZ(d);
    }

    public synchronized double getBunkerMaxZ() {
        return this.model.getBunkerMaxZ();
    }

    public synchronized void setBunkerMaxZ(double d) {
        this.model.setBunkerMaxZ(d);
    }

    public synchronized double getEarthGravity() {
        return this.model.getEarth().getGravity();
    }

    public synchronized void setEarthGravity(double d) {
        this.model.getEarth().setGravity(d);
    }

    public synchronized double getBallDensity() {
        return this.model.getBallDensity();
    }

    public synchronized void setBallDensity(double d) {
        this.model.setBallDensity(d);
    }

    public synchronized double getBallElasticityModulus() {
        return this.model.getBallElasticityModulus();
    }

    public synchronized void setBallElasticityModulus(double d) {
        this.model.setBallElasticityModulus(d);
    }

    public synchronized double getBallFrictionCoefficient() {
        return this.model.getBallFrictionCoefficient();
    }

    public synchronized void setBallFrictionCoefficient(double d) {
        this.model.setBallFrictionCoefficient(d);
    }

    public synchronized double getMediumResistanceCoefficient() {
        return this.model.getPhysicalMedium().getResistanceCoefficient();
    }

    public synchronized void setMediumResistanceCoefficient(double d) {
        this.model.getPhysicalMedium().setResistanceCoefficient(d);
    }

    public synchronized boolean getViscousForces() {
        return this.model.movementIntegrator.getViscousForces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setViscousForces(boolean bl) {
        this.wantToChangeModel = true;
        try {
            this.waitForSafeModeForChangingModel();
            this.model.movementIntegrator.setViscousForces(bl);
        }
        finally {
            this.notifyAll();
            this.wantToChangeModel = false;
        }
    }

    public synchronized double getAccelerationLimit() {
        return this.model.movementIntegrator.getAccelerationLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAccelerationLimit(double d) {
        this.wantToChangeModel = true;
        try {
            this.waitForSafeModeForChangingModel();
            this.model.movementIntegrator.setAccelerationLimit(d);
        }
        finally {
            this.notifyAll();
            this.wantToChangeModel = false;
        }
    }

    public synchronized double getVelocityLimit() {
        return this.model.movementIntegrator.getVelocityLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setVelocityLimit(double d) {
        this.wantToChangeModel = true;
        try {
            this.waitForSafeModeForChangingModel();
            this.model.movementIntegrator.setVelocityLimit(d);
        }
        finally {
            this.notifyAll();
            this.wantToChangeModel = false;
        }
    }

    public synchronized double getT() {
        return this.model.movementIntegrator.getT();
    }

    public synchronized void setT(double d) {
        this.model.movementIntegrator.setT(d);
    }

    public synchronized double getDeltaT() {
        return this.model.movementIntegrator.getDeltaT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDeltaT(double d) {
        this.wantToChangeModel = true;
        try {
            this.waitForSafeModeForChangingModel();
            this.model.movementIntegrator.setDeltaT(d);
        }
        finally {
            this.notifyAll();
            this.wantToChangeModel = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAll() {
        this.wantToChangeModel = true;
        try {
            this.waitForSafeModeForChangingModel();
            this.model.removeAll();
        }
        finally {
            this.controller.requestRedraw();
            this.wantToChangeModel = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addInitialItems() {
        this.wantToChangeModel = true;
        try {
            this.waitForSafeModeForChangingModel();
            this.model.addInitialItems();
        }
        finally {
            this.controller.requestRedraw();
            this.wantToChangeModel = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addElasticBall(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.wantToChangeModel = true;
        try {
            this.waitForSafeModeForChangingModel();
            ElasticBall elasticBall = new ElasticBall(d, d2, d3, d4, this.model.getBallDensity(), this.model.getBallElasticityModulus(), this.model.getBallFrictionCoefficient());
            elasticBall.setVelocity(d5, d6, d7);
            this.model.getItemSet().add(elasticBall);
        }
        finally {
            this.controller.requestRedraw();
            this.wantToChangeModel = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addNonintersectingRandomElasticBallsInBunker(int n, double d, double d2, double d3, double d4) {
        this.wantToChangeModel = true;
        try {
            this.waitForSafeModeForChangingModel();
            this.model.addNonintersectingRandomElasticBallsInBunker(n, d, d2, d3, d4);
        }
        finally {
            this.controller.requestRedraw();
            this.wantToChangeModel = false;
        }
    }

    public synchronized double getNumberOfParallelTasks() {
        return this.model.movementIntegrator.getNumberOfParallelTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNumberOfParallelTasks(int n) {
        this.wantToChangeModel = true;
        try {
            this.waitForSafeModeForChangingModel();
            this.model.movementIntegrator.setNumberOfParallelTasks(n);
        }
        finally {
            this.controller.requestRedraw();
            this.wantToChangeModel = false;
        }
    }

    public synchronized int getMovementIntegratorCode() {
        return this.model.getMovementIntegratorCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMovementIntegrator(int n) {
        this.wantToChangeModel = true;
        try {
            this.waitForSafeModeForChangingModel();
            this.model.setMovementIntegrator(n);
        }
        finally {
            this.controller.requestRedraw();
            this.wantToChangeModel = false;
        }
    }

    public synchronized String getItemColor() {
        Color color = this.view.getItemColoringRule().getColor();
        return String.format("#%02X%02X%02X%02X", color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public synchronized void setItemColor(String string) {
        this.view.getItemColoringRule().setColor(MovingSpheresView.decodeColorWithAlpha(string));
        this.controller.requestRedraw();
    }

    public synchronized String getBunkerWallColor() {
        Color color = this.view.getBunkerWallColoringRule().getColor();
        return String.format("#%02X%02X%02X%02X", color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public synchronized void setBunkerWallColor(String string) {
        this.view.getBunkerWallColoringRule().setColor(MovingSpheresView.decodeColorWithAlpha(string));
        this.controller.requestRedraw();
    }

    public double getCoordinateOriginX() {
        return this.controller.getCoordinateOriginX();
    }

    public double getCoordinateOriginY() {
        return this.controller.getCoordinateOriginY();
    }

    public double getCoordinateOriginZ() {
        return this.controller.getCoordinateOriginZ();
    }

    public void setCoordinatesOrigin(double d, double d2, double d3) {
        this.controller.setCoordinatesOrigin(d, d2, d3);
    }

    public double getScale() {
        return this.controller.getScale();
    }

    public void setScale(double d) {
        this.controller.setScale(d);
    }

    public void setOrientation(double d, double d2, double d3, double d4, double d5, double d6) {
        this.controller.setOrientation(d, d2, d3, d4, d5, d6);
    }

    public void rotate(double d, double d2, double d3) {
        this.controller.rotate(d, d2, d3);
    }

    public double getZCut() {
        return this.controller.getZCut();
    }

    public void setZCut(double d) {
        this.controller.setZCut(d);
    }

    public void setDefaultPositionIJ() {
        this.controller.setDefaultPositionIJ();
    }

    public synchronized void setDefaultPositionIK() {
        this.controller.setDefaultPositionIK();
    }

    public synchronized double getRefreshTime() {
        return this.refreshTime;
    }

    public synchronized void setRefreshTime(double d) {
        this.refreshTime = d;
    }

    public String getAppletInfo() {
        return "Name: MovingSpheres\nAuthor: Daniel Alievsky\nVersion: 1.0\n";
    }

    public String toString() {
        return "Successfully loaded Java applet \"Moving Spheres, Common Model\"\n" + this.getAppletInfo();
    }

    protected MovingSpheresModel createModel() {
        return new MovingSpheresModel(this);
    }

    protected MovingSpheresView createView() {
        return new MovingSpheresView(this, this.getWidth(), this.getHeight());
    }

    protected MovingSpheresController createController() {
        return new MovingSpheresController(this.view, this, this);
    }

    protected void waitForSafeModeForChangingModel() {
        long l = System.currentTimeMillis();
        while (!this.safeModeForChangingModel) {
            this.notifyAll();
            long l2 = System.currentTimeMillis() - l;
            if (l2 >= 3000L) {
                throw new IllegalStateException("Cannot modify model because it is in progress during " + l2 + " milliseconds");
            }
            try {
                this.wait(3000L - l2);
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException("Cannot modify model: " + interruptedException);
            }
        }
    }

    private synchronized void initGUI() {
        this.view = this.createView();
        this.controller = this.createController();
        this.add((Component)this.controller, "Center");
        this.invalidate();
        this.notifyAll();
    }

    private synchronized void indicateStop() {
        this.runThread = null;
        this.stopRequested = false;
        this.safeModeForChangingModel = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() throws InterruptedException {
        long l = System.nanoTime();
        long l2 = -1L;
        long l3 = 0L;
        while (!this.stopRequested) {
            MovingSpheresApplet movingSpheresApplet = this;
            synchronized (movingSpheresApplet) {
                this.safeModeForChangingModel = true;
                this.notifyAll();
                while (this.wantToChangeModel || this.controller == null || !this.controller.isSomethingRequested() && !this.stopRequested && !this.movingActive) {
                    this.wait();
                }
                this.safeModeForChangingModel = false;
            }
            if (this.controller.checkAndClearConsoleDumpRequest()) {
                this.view.printAllItemsDump(this.model, System.out);
            }
            if (this.movingActive) {
                this.model.movementIntegrator.resetCounters();
                this.model.movementIntegrator.performIteration();
                long l4 = System.nanoTime();
                if (this.refreshTime <= 0.0 || (double)(l4 - l) > 1.0E9 * this.refreshTime) {
                    this.controller.requestRedraw();
                    this.showStatus(this.view.movementStatusLine(this.model, l4 - l, l3 - l2));
                }
            }
            if (this.controller.checkAndClearRedrawRequest()) {
                long l5 = System.nanoTime();
                this.view.buildModelImage(this, this.model, this.getWidth(), this.getHeight());
                long l6 = System.nanoTime();
                this.repaint();
                if (!this.controller.isMouseStatusActive() && !this.movingActive) {
                    this.showStatus(String.format(Locale.US, "Model image (%d items) rebuilt in %.3f ms", this.model.getItemSet().size(), (double)(l6 - l5) * 1.0E-6));
                }
                l2 = l3;
                l = System.nanoTime();
            }
            ++l3;
        }
    }

    class RunThread
    extends Thread {
        RunThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            System.out.println("MovingSpheresApplet started");
            try {
                MovingSpheresApplet.this.doRun();
            }
            catch (Throwable throwable) {
                MovingSpheresApplet.this.showStatus("Applet interrupted by exception: " + throwable);
                throwable.printStackTrace();
            }
            finally {
                System.out.println("MovingSpheresApplet stopped");
                MovingSpheresApplet.this.indicateStop();
            }
        }
    }
}

