/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import net.algart.drawing3d.Orientation3D;
import net.algart.model3d.common.movement.MovingSpheresView;
import net.algart.model3d.common.movement.StatusShower;

public class MovingSpheresController
extends JComponent {
    protected final MovingSpheresView view;
    protected final Object lock;
    protected final StatusShower statusShower;
    private volatile boolean redrawRequested = true;
    private volatile boolean consoleDumpRequested = false;
    private volatile boolean mouseStatusActive = false;
    private static final long serialVersionUID = -9144238806069937860L;

    public MovingSpheresController(MovingSpheresView movingSpheresView, Object object, StatusShower statusShower) {
        if (movingSpheresView == null) {
            throw new NullPointerException("Null view argument");
        }
        if (object == null) {
            throw new NullPointerException("Null lock argument");
        }
        if (statusShower == null) {
            throw new NullPointerException("Null statusShower argument");
        }
        this.view = movingSpheresView;
        this.lock = object;
        this.statusShower = statusShower;
        this.addKeyListener(new KeyHandler());
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.addMouseWheelListener(mouseHandler);
        this.addComponentListener(new ComponentHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        BufferedImage bufferedImage;
        Object object = this.lock;
        synchronized (object) {
            bufferedImage = this.view.getModelImage();
        }
        if (bufferedImage != null) {
            graphics.drawImage(bufferedImage, 0, 0, null);
        } else {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.BLACK);
            graphics.drawString("Image is not ready yet...", 5, 5 + graphics.getFontMetrics().getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSomethingRequested() {
        Object object = this.lock;
        synchronized (object) {
            return this.redrawRequested || this.consoleDumpRequested;
        }
    }

    public boolean isRedrawRequested() {
        return this.redrawRequested;
    }

    public boolean isConsoleDumpRequested() {
        return this.consoleDumpRequested;
    }

    public boolean isMouseStatusActive() {
        return this.mouseStatusActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRedraw() {
        Object object = this.lock;
        synchronized (object) {
            this.redrawRequested = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestConsoleDump() {
        Object object = this.lock;
        synchronized (object) {
            this.consoleDumpRequested = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndClearRedrawRequest() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.redrawRequested;
            this.redrawRequested = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndClearConsoleDumpRequest() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.consoleDumpRequested;
            this.consoleDumpRequested = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCoordinateOriginX() {
        Object object = this.lock;
        synchronized (object) {
            return this.view.getCoordinateSystem().getOriginX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCoordinateOriginY() {
        Object object = this.lock;
        synchronized (object) {
            return this.view.getCoordinateSystem().getOriginY();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCoordinateOriginZ() {
        Object object = this.lock;
        synchronized (object) {
            return this.view.getCoordinateSystem().getOriginZ();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoordinatesOrigin(double d, double d2, double d3) {
        Object object = this.lock;
        synchronized (object) {
            if (d != this.view.getCoordinateSystem().getOriginX() || d2 != this.view.getCoordinateSystem().getOriginY() || d3 != this.view.getCoordinateSystem().getOriginZ()) {
                this.view.getCoordinateSystem().setOrigin(d, d2, d3);
                this.requestRedraw();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getScale() {
        Object object = this.lock;
        synchronized (object) {
            return this.view.getCoordinateSystem().getScale();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(double d) {
        Object object = this.lock;
        synchronized (object) {
            if (d != this.view.getCoordinateSystem().getScale()) {
                this.view.getCoordinateSystem().setScale(d);
                this.requestRedraw();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrientation(double d, double d2, double d3, double d4, double d5, double d6) {
        Object object = this.lock;
        synchronized (object) {
            Orientation3D orientation3D = Orientation3D.getInstance(d, d2, d3, d4, d5, d6);
            if (!orientation3D.equals(this.view.getCoordinateSystem().getOrientation())) {
                this.view.getCoordinateSystem().setOrientation(orientation3D);
                this.requestRedraw();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate(double d, double d2, double d3) {
        Object object = this.lock;
        synchronized (object) {
            Orientation3D orientation3D = this.view.getCoordinateSystem().getOrientation().rotate(d * Math.PI / 180.0, d2 * Math.PI / 180.0, d3 * Math.PI / 180.0);
            if (!orientation3D.equals(this.view.getCoordinateSystem().getOrientation())) {
                this.view.getCoordinateSystem().setOrientation(orientation3D);
                this.requestRedraw();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getZCut() {
        Object object = this.lock;
        synchronized (object) {
            return this.view.getZCut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZCut(double d) {
        Object object = this.lock;
        synchronized (object) {
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 1.0) {
                d = 1.0;
            }
            if (d != this.view.getZCut()) {
                this.view.setZCut(d);
                this.requestRedraw();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultPositionIJ() {
        Object object = this.lock;
        synchronized (object) {
            this.view.getCoordinateSystem().setOrigin(0.5 * (double)this.getWidth() * (double)this.view.getAntialiasingScale(), 0.5 * (double)this.getHeight() * (double)this.view.getAntialiasingScale(), 0.0);
            this.view.getCoordinateSystem().setOrientation(Orientation3D.DEFAULT);
            this.view.setZCut(1.0);
            this.requestRedraw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultPositionIK() {
        Object object = this.lock;
        synchronized (object) {
            this.view.getCoordinateSystem().setOrigin(0.5 * (double)this.getWidth() * (double)this.view.getAntialiasingScale(), (this.getHeight() - 20) * this.view.getAntialiasingScale(), 0.0);
            this.view.getCoordinateSystem().setOrientation(Orientation3D.DEFAULT.rotateI(1.5707963267948966));
            this.view.setZCut(1.0);
            this.requestRedraw();
        }
    }

    class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            MovingSpheresController.this.requestRedraw();
        }
    }

    class MouseHandler
    extends MouseAdapter {
        private int lastX;
        private int lastY;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.lastX = mouseEvent.getX();
            this.lastY = mouseEvent.getY();
            this.mouseDragInfo(mouseEvent);
            MovingSpheresController.this.requestFocus();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MovingSpheresController.this.statusShower.showStatus("");
            MovingSpheresController.this.mouseStatusActive = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiersEx();
            if ((n & 0x40) != 0) {
                double d = MovingSpheresController.this.getCoordinateOriginX();
                double d2 = MovingSpheresController.this.getCoordinateOriginY();
                double d3 = MovingSpheresController.this.getCoordinateOriginZ();
                MovingSpheresController.this.setCoordinatesOrigin(d + (double)(mouseEvent.getX() - this.lastX), d2 + (double)(mouseEvent.getY() - this.lastY), d3);
            } else if ((n & 0xA00) != 0) {
                MovingSpheresController.this.setScale(MovingSpheresController.this.getScale() * Math.pow(2.0, 3.0 * (double)(-mouseEvent.getY() - -this.lastY) / (double)MovingSpheresController.this.getHeight()));
            } else if ((n & 0x1080) != 0) {
                MovingSpheresController.this.setZCut(MovingSpheresController.this.getZCut() + (double)(-mouseEvent.getY() - -this.lastY) / (double)MovingSpheresController.this.getHeight());
            } else {
                MovingSpheresController.this.rotate((double)(this.lastY - mouseEvent.getY()) / (double)MovingSpheresController.this.getHeight() * 360.0, (double)(mouseEvent.getX() - this.lastX) / (double)MovingSpheresController.this.getWidth() * 360.0, 0.0);
            }
            this.lastX = mouseEvent.getX();
            this.lastY = mouseEvent.getY();
            this.mouseDragInfo(mouseEvent);
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            MovingSpheresController.this.setScale(MovingSpheresController.this.getScale() * Math.pow(2.0, 10.0 * (double)(-mouseWheelEvent.getWheelRotation()) / (double)MovingSpheresController.this.getHeight()));
        }

        private void mouseDragInfo(MouseEvent mouseEvent) {
            if (mouseEvent.isShiftDown()) {
                MovingSpheresController.this.statusShower.showStatus("Please move mouse to drag the objects (Home/End keys reset coordinates)");
            } else if (mouseEvent.isControlDown()) {
                MovingSpheresController.this.statusShower.showStatus("Please move mouse up/down to drag the secant plane nearer/further (Home/End keys reset coordinates)");
            } else if (mouseEvent.isAltDown()) {
                MovingSpheresController.this.statusShower.showStatus("Please move mouse up/down or scroll mouse wheel to scale the objects (Home/End keys reset coordinates)");
            } else {
                MovingSpheresController.this.statusShower.showStatus("Please move mouse to rotate (drag with Shift, cut with Ctrl, scale with Alt or mouse wheel; Home/End keys reset key reset coordinates)");
            }
            MovingSpheresController.this.mouseStatusActive = true;
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 36: {
                    MovingSpheresController.this.setDefaultPositionIJ();
                    break;
                }
                case 35: {
                    MovingSpheresController.this.setDefaultPositionIK();
                    break;
                }
                case 80: {
                    if (!keyEvent.isControlDown() || !keyEvent.isAltDown()) break;
                    MovingSpheresController.this.requestConsoleDump();
                }
            }
        }
    }
}

