/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement.model;

import java.util.Collection;
import net.algart.model3d.common.movement.model.AbstractMovementIntegrator;
import net.algart.model3d.common.movement.model.HavingMass;
import net.algart.model3d.common.movement.model.HavingVelocity;
import net.algart.model3d.common.movement.model.InteractionRule;
import net.algart.model3d.common.movement.model.Item;
import net.algart.model3d.common.movement.model.ItemSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EulerMovementIntegrator
extends AbstractMovementIntegrator {
    private double[] dX = new double[0];
    private double[] dY = new double[0];
    private double[] dZ = new double[0];
    private double[] dVX = new double[0];
    private double[] dVY = new double[0];
    private double[] dVZ = new double[0];

    private EulerMovementIntegrator(ItemSet itemSet, Collection<InteractionRule> collection, double d) {
        super(itemSet, collection, d);
    }

    public static EulerMovementIntegrator getEulerIntegrator(ItemSet itemSet, Collection<InteractionRule> collection, double d) {
        return new EulerMovementIntegrator(itemSet, collection, d);
    }

    @Override
    public void performIteration() {
        long l = System.nanoTime();
        this.preprocess();
        long l2 = System.nanoTime();
        double d = this.getDeltaT();
        this.calculateLeftSide(this.dX, this.dY, this.dZ, this.dVX, this.dVY, this.dVZ, d);
        long l3 = System.nanoTime();
        for (int i = 0; i < this.n; ++i) {
            Item item = this.itemSet.get(i);
            if (!(item instanceof HavingVelocity) || !(item instanceof HavingMass)) continue;
            HavingVelocity havingVelocity = (HavingVelocity)item;
            double d2 = havingVelocity.getCenterX();
            double d3 = havingVelocity.getCenterY();
            double d4 = havingVelocity.getCenterZ();
            double d5 = havingVelocity.getVelocityX();
            double d6 = havingVelocity.getVelocityY();
            double d7 = havingVelocity.getVelocityZ();
            havingVelocity.setCenter(d2 + this.dX[i], d3 + this.dY[i], d4 + this.dZ[i]);
            havingVelocity.setVelocity(d5 + this.dVX[i], d6 + this.dVY[i], d7 + this.dVZ[i]);
        }
        long l4 = System.nanoTime();
        this.setT(this.getT() + d);
    }

    @Override
    protected void preprocess() {
        int n = this.n;
        super.preprocess();
        if (this.n != n) {
            this.dX = new double[this.n];
            this.dY = new double[this.n];
            this.dZ = new double[this.n];
            this.dVX = new double[this.n];
            this.dVY = new double[this.n];
            this.dVZ = new double[this.n];
        }
    }

    public String toString() {
        return "Euler method";
    }
}

