/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement.model;

import net.algart.model3d.common.movement.model.HavingVelocity;
import net.algart.model3d.common.movement.model.InteractionRule;
import net.algart.model3d.common.movement.model.Item;
import net.algart.model3d.common.movement.model.PhysicalMedium;
import net.algart.model3d.common.movement.model.Spherical;

public final class PhysicalMediumResistanceRule
implements InteractionRule {
    public boolean isApplicable(Item item, Item item2) {
        return item2 instanceof PhysicalMedium && item instanceof Spherical && item instanceof HavingVelocity;
    }

    public boolean calculateForce(double[] dArray, Item item, Item item2, double d) {
        if (!(item2 instanceof PhysicalMedium && item instanceof Spherical && item instanceof HavingVelocity)) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return false;
        }
        double d2 = ((PhysicalMedium)item2).getResistanceCoefficient();
        double d3 = 2.0 * ((Spherical)item).getRadius();
        double d4 = ((HavingVelocity)item).getVelocityX();
        double d5 = ((HavingVelocity)item).getVelocityY();
        double d6 = ((HavingVelocity)item).getVelocityZ();
        dArray[0] = -d2 * d4 * d3;
        dArray[1] = -d2 * d5 * d3;
        dArray[2] = -d2 * d6 * d3;
        return d4 != 0.0 || d5 != 0.0 || d6 != 0.0;
    }
}

